function deltaNimax = WCDMARateMatchingInit(numBits, tti, RMAttribute, posTrCh, slotFormat, numPhCH)
%
% Computes ANi for Rate Matching. ANi is an intermidiate variable that indicates
% whether RM needs to puncture or repeat or do nothing.
%

%--- Load Slot Format table
load slotFormatTable;

numTrCh = length(numBits);

%--- Check for Fixed or Flexible position of TrCh 
if posTrCh == 0
       
    % Max number of bits per TFS(l) (currently l=0) per Transport Channel
    maxNumBits = max(numBits,1);
    
    %Compute the number of frames in a TT1 for all the transport channels    
    F = tti./10;
    
    % Compute Ni       
    Ni = maxNumBits./F;
    
    % Get Ndata1 and Ndata2 using slotFormat
    Ndata1 = slotFormatTable(slotFormat+1, 4);
    Ndata2 = slotFormatTable(slotFormat+1, 5);

    % P(=numPhCH) is the num of Physical channels at CCtrCh signalled by higher layers 
    Ndata = numPhCH*15*(Ndata1+Ndata2);

    % Calculate the Variable Z (defined for all TFC j) (currently j=0)
    den = RMAttribute*Ni'; % Denominator value for Z

    for i=1:numTrCh
        
        Z(i)= floor((RMAttribute(1:i)*Ni(1:i)')* Ndata/den);
        if (i>1)
            deltaNi(i) = Z(i) - Z(i-1) - Ni(i);
        else
            deltaNi(1) = Z(1) - Ni(1);
        end
    end
    
    deltaNimax = F.*deltaNi;
        
    % deltaNimax is the variable generated by the initialization 
    % program of the Rate Matching code and used by certain other 
    % blocks in the model
    
    %********************************************%
    % Code for Compressed Mode
    %********************************************%
    
    Npimax = 0;
    
    deltaNimax = deltaNimax - Npimax;
    
else % Flexible Position
   
    %********************************************%
    % Code to be put in for Flexible TrCH position
    %********************************************%
    
end


